<?php

header('Content-Type: text/html; charset=utf-8');
define('DIR_MAIN', './');
include('./includes/config.php');

$sql = $objSql;

if(!empty($_POST['dateToFill']) && !empty($_POST['dateSource'])) {
    $dateToFill = new DateTime(date('Y-m-d', strtotime($_POST['dateToFill'])));
    $dateSource = new DateTime(date('Y-m-d', strtotime($_POST['dateSource'])));
    $fillZeros = !!$_POST['fillZeros'];

    $todayDate = new DateTime(date('Y-m-d'));
    
    $total = 0;
    $updatedKeyIds = [];
    
    $keys = $sql->query("SELECT `site_id`, `key_id` FROM `" . $sql->getDbSettings('prefix') . "keys` WHERE `pause` = '0' ORDER BY `key_id` ASC", 0);
    while ($key = mysqli_fetch_array($keys)) {

        $positionOnFillDate = $sql->query("SELECT `position` FROM `" . $sql->getDbSettings('prefix') . "history` WHERE `site_id` = '" . $key['site_id'] . "' AND `key_id`='" . $key['key_id'] . "' AND `data` = '" . $dateToFill->format("Y-m-d") . "'", 1);

        if (empty($positionOnFillDate) || ($fillZeros && $positionOnFillDate['position'] == 0)) {
            $position = $sql->query("SELECT `position` FROM `" . $sql->getDbSettings('prefix') . "history` WHERE `site_id` = '" . $key['site_id'] . "' AND `key_id`='" . $key['key_id'] . "' AND `data` = '" . $dateSource->format("Y-m-d") . "'", 1);

            if (!empty($position)) {
                if (!empty($positionOnFillDate) && $positionOnFillDate['position'] != $position['position']) {
                    $sql->query("UPDATE `" . $sql->getDbSettings('prefix') . "history` SET `position` = '" . $position['position'] . "' WHERE `site_id` = '" . $key['site_id'] . "' AND `key_id`='" . $key['key_id'] . "' AND `data` = '" . $dateToFill->format("Y-m-d") . "'", 0);
                    $updatedKeyIds[] = $key['key_id'];
                    $total++;
                } elseif (empty($positionOnFillDate) ) {
                    $sql->query("INSERT INTO `" . $sql->getDbSettings('prefix') . "history` (site_id, key_id, position, data) VALUES('" . $key['site_id'] . "', '" . $key['key_id'] . "', '" . $position['position'] . "', '" . $dateToFill->format("Y-m-d") . "')", 0);
                    $updatedKeyIds[] = $key['key_id'];
                    $total++;
                }
            }
        }
    }

    if (!empty($updatedKeyIds) && $dateToFill->format('Y-m-d') == $todayDate->format('Y-m-d')) {
        foreach ($updatedKeyIds as $keyId) {
            $sql->query("UPDATE `" . $sql->getDbSettings('prefix') . "keys` SET `last_check_time` = NOW() WHERE `key_id`='" . $keyId . "'", 0);
        }
    }
    
    $alert = sprintf('Uzupełniono %d pozycji w dniu %s', $total, $dateToFill->format("Y-m-d"));
}

$dateToFill = new DateTime('yesterday');
$dateSource = new DateTime('now');

?>


<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Stat4Seo - uzupełnij pozycje</title>

        <script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
        <script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
        <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.0/js/bootstrap-datepicker.min.js"></script>
        <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.0/locales/bootstrap-datepicker.pl.min.js"></script>

        <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
        <link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap-theme.min.css">
        <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.6.0/css/bootstrap-datepicker.min.css">

        <style>
        body {
            padding-top: 70px;
        }
        </style>

        <script>
            $( document ).ready(function() {
                $('.hasDatePicker').datepicker({
                    format: "yyyy-mm-dd",
                    language: "pl",
                    orientation: "bottom auto",
                    autoclose: true
                });
            });
        </script>
    </head>

    <body>

        <nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
            <div class="container">
                <div class="navbar-header">
                    <a class="navbar-brand" href="#">Uzupełnij pozycje</a>
                </div>
            </div>
        </nav>

        <div class="container">

            <div class="row">
                <div class="col-lg-12">
                    <h1>Skrypt do uzupełniania brakujących pozycji</h1>
                    <p class="lead">Skrypt uzupełnia <u>brakujące</u> wyniki lub <u>pozycje 0</u> w wybranym dniu, korzystając z wyników z innego wybranego dnia.</p>
                    
                    <?php if(isset($alert)):?>
                    <div class="alert alert-success"><?php echo $alert; ?></div>
                    <?php endif; ?>
                    
                    <form name="" action="" method="POST">
                        <div class="form-group">
                          <label for="dateToFill">Dzień w którym chcemy uzupełnić brakujące pozycje</label>
                          <input type="text" name="dateToFill" class="form-control hasDatePicker" value="<?php echo $dateToFill->format("Y-m-d"); ?>" id="dateToFill">
                        </div>
                        <div class="form-group">
                          <label for="dateSource">Dzień z którego chcemy użyć pozycji do uzupełniania</label>
                          <input type="text" name="dateSource" class="form-control hasDatePicker" value="<?php echo $dateSource->format("Y-m-d"); ?>" id="dateSource">
                        </div>

                        <div class="form-group">
                            <label for="fillZeros">Uzupełniaj też 0 (domyślnie skrypt uzupełnia tylko brakujące pozycje, czyli takie gdzie w tabelce z pozycjami jest "-", ta opcja umożliwia uzupełnianie też pozycji "0")</label>
                            <select name="fillZeros" class="form-control" id="fillZeros">
                                <option>Nie, uzupełniaj TYLKO brakujące pozycje</option>
                                <option>Tak, uzupełniaj brakujące pozycje oraz 0</option>
                            </select>
                        </div>

                    <button type="submit" class="btn btn-default">Wykonaj</button>
                  </form>
                </div>
            </div>

        </div>
    </body>

</html>